within OpenHPL.Tests;
model HPModelManLin
  inner OpenHPL.Constants Const;
  import Modelica.Constants.pi;
  parameter Real H_r = 48, H_i = 23, H_p = 428.5, H_s = 120, H_d = 0.5, H_t = 5;
  parameter Real L_i = 6600, L_p = 600, L_s = 140, L_d = 600;
  parameter Real D_i = 5.8, D_p = 3, D_s = 3.4, D_d = 5.8;
  parameter Real C_v = 3.7, fD = 0.043;
  parameter Real h_s0 = 69.6998, Vdot_s0 = 0, Vdot_p0 = 19.0768, Vdot_i0 = 19.0768;
  input Real u_v;
  Real A_i = D_i ^ 2 * pi / 4, A_p = D_p ^ 2 * pi / 4, A_s = D_s ^ 2 * pi / 4, A_d = D_d ^ 2 * pi / 4;
  Real cos_theta_i = H_i / L_i, cos_theta_p = H_p / L_p, cos_theta_s = H_s / L_s, cos_theta_d = H_d / L_d;
  Real p_r = Const.p_a + Const.g * Const.rho * H_r, p_t = Const.p_a + Const.g * Const.rho * H_t;
  Real Z_i = A_i / L_i, Z_p = A_p / L_p, Z_s = A_s * cos_theta_s / h_s, Z_d = A_d / L_d;
  Real B_i = D_i / A_i ^ 2, B_p = D_p / A_p ^ 2, B_s = D_s / A_s ^ 2, B_d = D_d / A_d ^ 2;
  Real fD_i = fD, fD_p = fD, fD_s = fD, fD_d = fD;
  Real p_tr1, p_n, K_dp, K_p, K_z, K_pd, K_pdz, K_pp, Z_ss;
  Real h_s, Vdot_s, Vdot_p, Vdot_i;
  Real dpndVp, dpndVi2, dpndVs, dpndhs, dptr1dVp, dKpdhs, dpndu, dptr1du, dpndVp1, dpndVp2, dpndVs1, dpndVi1;
  Real dVpdVp, dVpdVs, dVpdhs, dVpdVi2, dVsdVp, dVsdVs, dVsdhs, dhsdVp, dhsdVs, dhsdhs, dhsdVi, dVidhs, dVpdu, dVsdu, dhsdu, dVidu, dVpdVp1, dVpdVp2, dVpdVs1, dVpdVi1, dVsdVp1, dVsdVs1, dVsdVi1, dVidVp1, dVidVp2, dVidVs1, dVidVi1, dVidVi2, dhsdVp2, dhsdVi2;
  Real A[3, 3], B[3, 1], x[3, 1], xx, A2[3, 3], B2[3, 1], x2[3, 1], xx2, A1[4, 4], B1[4, 1], x1[4, 1];
initial equation
  h_s = h_s0;
  Vdot_s = Vdot_s0;
  Vdot_p = Vdot_p0;
  Vdot_i = Vdot_i0;
  x = [Vdot_p0; Vdot_s0; h_s0];
  x1 = [Vdot_p0; Vdot_s0; h_s0; Vdot_i0];
  x2 = [Vdot_p0; h_s0; Vdot_i0];
equation
  //Vdot_i = Vdot_s + Vdot_p;
  K_dp = Z_d / (Z_d + Z_p);
  K_z = K_dp / Z_d;
  K_p = 1 / (Z_i + Z_s + K_pdz);
  K_pd = Z_p * K_dp / Z_d;
  K_pdz = Z_p * K_dp;
  p_n = K_p * (Z_i * p_r + Z_s * Const.p_a + K_pdz * (Vdot_p ^ 2 * Const.p_a / (C_v ^ 2 * u_v ^ 2) + p_t) + Const.rho * Const.g * (A_p * cos_theta_p * (K_pd - 1) - K_pd * A_d * cos_theta_d + A_s * cos_theta_s + A_i * cos_theta_i) + 1 / 8 * pi * Const.rho * (fD_s * B_s * Vdot_s * abs(Vdot_s) + (fD_d * B_d * K_pd + fD_p * B_p * (1 - K_pd)) * Vdot_p * abs(Vdot_p) - fD_i * B_i * Vdot_i * abs(Vdot_i)));
  p_tr1 = K_z * (Z_p * p_n + Z_d * (Vdot_p ^ 2 * Const.p_a / (C_v ^ 2 * u_v ^ 2) + p_t) + Const.rho * Const.g * (A_p * cos_theta_p - A_d * cos_theta_d) + 1 / 8 * pi * Const.rho * Vdot_p * abs(Vdot_p) * (fD_d * B_d - fD_p * B_p));
  der(h_s) = Vdot_s * cos_theta_s / A_s;
  der(Vdot_s) = Z_s / Const.rho * (p_n - Const.p_a) - A_s * Const.g * cos_theta_s - 1 / 8 * pi * fD_s * B_s * Vdot_s * abs(Vdot_s);
  der(Vdot_p) = Z_p / Const.rho * (p_n - p_tr1) + A_p * Const.g * cos_theta_p - 1 / 8 * pi * fD_p * B_p * Vdot_p * abs(Vdot_p);
  der(Vdot_i) = Z_i / Const.rho * (p_r - p_n) + A_i * Const.g * cos_theta_i - 1 / 8 * pi * fD_i * B_i * Vdot_i * abs(Vdot_i);
  x[2, 1] = xx - x[1, 1];
  //x1[4,1] = x1[2,1] + x1[1,1];
  x2[3, 1] = xx2 + x2[1, 1];
  K_pp = 1 / (Z_i + Z_ss + K_pdz);
  Z_ss = A_s * cos_theta_s / h_s0;
  A = [dVpdVp, dVpdVs, dVpdhs; dVsdVp, dVsdVs, dVsdhs; dhsdVp, dhsdVs, dhsdhs];
  A1 = [dVpdVp1, dVpdVs1, dVpdhs, dVpdVi1; dVsdVp1, dVsdVs1, dVsdhs, dVsdVi1; dhsdVp, dhsdVs, dhsdhs, dhsdVi; dVidVp1, dVidVs1, dVidhs, dVidVi1];
  A2 = [dVpdVp2, dVpdhs, dVpdVi2; dhsdVp2, dhsdhs, dhsdVi2; dVidVp2, dVidhs, dVidVi2];
  B = [dVpdu; dVsdu; dhsdu];
  B1 = [dVpdu; dVsdu; dhsdu; dVidu];
  B2 = [dVpdu; dhsdu; dVidu];
  dVpdVp = Z_p / Const.rho * (dpndVp - dptr1dVp) - 1 / 4 * pi * fD_p * B_p * abs(Vdot_p0);
  dVpdVp1 = Z_p / Const.rho * (dpndVp1 - dptr1dVp) - 1 / 4 * pi * fD_p * B_p * abs(Vdot_p0);
  dVpdVp2 = Z_p / Const.rho * (dpndVp2 - dptr1dVp) - 1 / 4 * pi * fD_p * B_p * abs(Vdot_p0);
  dVpdVs = Z_p / Const.rho * (1 - K_z * Z_p) * dpndVs;
  dVpdVs1 = Z_p / Const.rho * (1 - K_z * Z_p) * dpndVs1;
  dVpdhs = Z_p / Const.rho * (1 - K_z * Z_p) * dpndhs;
  dVpdVi2 = Z_p / Const.rho * (1 - K_z * Z_p) * dpndVi2;
  dVpdVi1 = Z_p / Const.rho * (1 - K_z * Z_p) * dpndVi1;
  dVsdVp = Z_ss / Const.rho * dpndVp;
  dVsdVp1 = Z_ss / Const.rho * dpndVp1;
  dVsdVs = Z_ss / Const.rho * dpndVs - 1 / 4 * pi * fD_s * B_s * abs(Vdot_s0);
  dVsdVs1 = Z_ss / Const.rho * dpndVs1 - 1 / 4 * pi * fD_s * B_s * abs(Vdot_s0);
  dVsdhs = A_s * cos_theta_s / Const.rho / h_s0 * (1 / h_s0 * (Const.p_a - p_n) + dpndhs);
  dVsdVi1 = Z_ss / Const.rho * dpndVi1;
  dhsdVp = 0;
  dhsdVp2 = -cos_theta_s / A_s;
  dhsdVs = cos_theta_s / A_s;
  dhsdhs = 0;
  dhsdVi = 0;
  dhsdVi2 = cos_theta_s / A_s;
  dVidVp1 = -Z_i / Const.rho * dpndVp1;
  dVidVp2 = -Z_i / Const.rho * dpndVp2;
  dVidVs1 = -Z_i / Const.rho * dpndVs1;
  dVidhs = -Z_i / Const.rho * dpndhs;
  dVidVi1 = (-Z_i / Const.rho * dpndVi1) - 1 / 4 * pi * fD_i * B_i * abs(Vdot_i0);
  dVidVi2 = (-Z_i / Const.rho * dpndVi2) - 1 / 4 * pi * fD_i * B_i * abs(Vdot_i0);
  dptr1dVp = K_z * Z_p * dpndVp + K_dp * 2 * Vdot_p0 * Const.p_a / (C_v ^ 2 * u_v ^ 2) + 1 / 4 * pi * Const.rho * K_z * abs(Vdot_p0) * (fD_d * B_d - fD_p * B_p);
  dpndVp = K_pp * (K_pdz * 2 * Vdot_p0 * Const.p_a / (C_v ^ 2 * u_v ^ 2) + 1 / 4 * pi * Const.rho * ((fD_d * B_d * K_pd + fD_p * B_p * (1 - K_pd)) * abs(Vdot_p0) - fD_i * B_i * abs(Vdot_i0)));
  dpndVp1 = K_pp * (K_pdz * 2 * Vdot_p0 * Const.p_a / (C_v ^ 2 * u_v ^ 2) + 1 / 4 * pi * Const.rho * ((fD_d * B_d * K_pd + fD_p * B_p * (1 - K_pd)) * abs(Vdot_p0)));
  dpndVp2 = K_pp * (K_pdz * 2 * Vdot_p0 * Const.p_a / (C_v ^ 2 * u_v ^ 2) + 1 / 4 * pi * Const.rho * ((fD_d * B_d * K_pd + fD_p * B_p * (1 - K_pd)) * abs(Vdot_p0) + fD_s * B_s * abs(Vdot_s0)));
  dpndVs = K_pp * (1 / 4 * pi * Const.rho * (fD_s * B_s * abs(Vdot_s0) - fD_i * B_i * abs(Vdot_i0)));
  dpndVs1 = K_pp * (1 / 4 * pi * Const.rho * (fD_s * B_s * abs(Vdot_s0)));
  dpndVi1 = K_pp * (-1 / 4 * pi * Const.rho * (fD_i * B_i * abs(Vdot_i0)));
  dpndVi2 = K_pp * (-1 / 4 * pi * Const.rho * (fD_i * B_i * abs(Vdot_i0) + fD_s * B_s * abs(Vdot_s0)));
  dpndhs = (Z_i * p_r + Z_ss * Const.p_a + K_pdz * (Vdot_p0 ^ 2 * Const.p_a / (C_v ^ 2 * u_v ^ 2) + p_t) + Const.rho * Const.g * (A_p * cos_theta_p * (K_pd - 1) - K_pd * A_d * cos_theta_d + A_s * cos_theta_s + A_i * cos_theta_i) + 1 / 8 * pi * Const.rho * (fD_s * B_s * Vdot_s0 * abs(Vdot_s0) + (fD_d * B_d * K_pd + fD_p * B_p * (1 - K_pd)) * Vdot_p0 * abs(Vdot_p0) - fD_i * B_i * Vdot_i0 * abs(Vdot_i0))) * dKpdhs - K_pp * A_s * cos_theta_s / h_s0 ^ 2 * Const.p_a;
  dKpdhs = A_s * cos_theta_s * K_pp ^ 2 / h_s0 ^ 2;
  dVpdu = Z_p / Const.rho * (dpndu - dptr1du);
  dVsdu = A_s * cos_theta_s / Const.rho / h_s0 * dpndu;
  dhsdu = 0;
  dVidu = -Z_i / Const.rho * dpndu;
  dpndu = -2 * K_pp * K_pdz * Vdot_p0 ^ 2 * Const.p_a / (C_v ^ 2 * u_v ^ 3);
  dptr1du = K_z * (Z_p * dpndu - 2 * Z_d * Vdot_p0 ^ 2 * Const.p_a / (C_v ^ 2 * u_v ^ 3));
  der(x) = A * x + B * u_v;
  der(x1) = A1 * x1 + B1 * u_v;
  der(x2) = A2 * x2 + B2 * u_v;
end HPModelManLin;
